<?php


class AdminCronController extends Am_Mvc_Controller_Grid
{
    public function checkAdminPermissions(Admin $admin)
    {
        return $admin->hasPermission(Am_Auth_Admin::PERM_SUPER_USER);
    }

    public function createGrid()
    {
        $ds = new Am_Query(new Am_Table($this->getDi()->db, '?_cron', 'cron_id'));
        $ds->setOrder('cron_id', 'DESC');
        $ds->addField("1000*(tm_finished-tm_started)", 'ms');
        $grid = new Am_Grid_ReadOnly('_cr', ___("Cron Log"), $ds, $this->_request, $this->view);
        $grid->setPermissionId(Am_Auth_Admin::PERM_SUPER_USER);
        $grid->addField('tm_cron', ___('Cron Start'), true, null, null, '10%')
            ->setGetFunction(function($r){return amDatetime($r->tm_cron);});
        $grid->addField('event', ___('Event'), true, null, null, '10%');
        $grid->addField('callback', ___('Callback'), true, null, null, '10%');
        $grid->addField('ms', ___('Task Time'), true, 'right', null, '10%')
            ->setRenderFunction(function($r, $field, $grid){
                $ms = sprintf('%.2f', $r->ms) ?: '-';
                $title = sprintf("%s - %s", $r->tm_started, $r->tm_finished);
                return "<td align='right'><span title='$title'>$ms</span></td>";
            });
        $grid->addField('error', ___('Error'), true, null, null, '10%');

//        $grid->addCallback(Am_Grid_ReadOnly::CB_TR_ATTRIBS, [$this,'getTrAttribs']);
//        $grid->addCallback(Am_Grid_Editable::CB_VALUES_TO_FORM, [$this, 'valuesToForm']);
//        $grid->addCallback(Am_Grid_Editable::CB_VALUES_FROM_FORM, [$this, 'valuesFromForm']);
        return $grid;
    }

}