<?php

class Am_Api_Access extends Am_ApiController_Table
{
    function setForInsert(Am_Record $record, array $vars)
    {
        parent::setForInsert($record, $vars);
        if (empty($record->expire_date))
        {
            $product = $this->getDi()->productTable->load($record->product_id);
            $p = new Am_Period($product->getBillingPlan()->first_period);
            $record->expire_date = $p->addTo($record->begin_date);
        }
    }

    function createRecord($vars)
    {
        $access = parent::createRecord($vars);
        Am_Di::getInstance()->emailTemplateTable->sendZeroAutoresponders($access->getUser(), $access);
        return $access;
    }
}